/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.core.storage.hikari;

import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Enumeration;
import net.impactdev.impactor.api.storage.StorageCredentials;
import net.impactdev.impactor.core.storage.hikari.HikariConnection;
import net.impactdev.impactor.relocations.com.zaxxer.hikari.HikariConfig;

public abstract class DriverBasedHikariConnection
extends HikariConnection {
    public DriverBasedHikariConnection(StorageCredentials credentials) {
        super(credentials);
    }

    protected abstract String driverClassName();

    protected abstract String driverJdbcIdentifier();

    @Override
    protected void configure(HikariConfig config, StorageCredentials credentials, HikariConnection.StorageConfiguration configuration) {
        config.setDriverClassName(this.driverClassName());
        config.setJdbcUrl(String.format("jdbc:%s://%s:%s/%s", this.driverJdbcIdentifier(), configuration.address(), configuration.port(), credentials.getDatabase()));
        config.setUsername(credentials.getUsername());
        config.setPassword(credentials.getPassword());
    }

    @Override
    protected void postInitialize() {
        super.postInitialize();
        DriverBasedHikariConnection.deregisterDriver(this.driverClassName());
    }

    private static void deregisterDriver(String driverClassName) {
        Enumeration<Driver> drivers = DriverManager.getDrivers();
        while (drivers.hasMoreElements()) {
            Driver driver = drivers.nextElement();
            if (!driver.getClass().getName().equals(driverClassName)) continue;
            try {
                DriverManager.deregisterDriver(driver);
            }
            catch (SQLException sQLException) {}
        }
    }
}

